/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lib.toma.animations.IEasing;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.engine.frame.MutableKeyframe;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorFrameProvider;
import lib.toma.animations.engine.screen.animator.ImportProjectScreen;
import lib.toma.animations.engine.screen.animator.MergeAnimationScreen;
import lib.toma.animations.engine.screen.animator.SetBackgroundAnimationScreen;
import lib.toma.animations.engine.screen.animator.dialog.AddEventDialog;
import lib.toma.animations.engine.screen.animator.dialog.AddFrameDialog;
import lib.toma.animations.engine.screen.animator.dialog.ChangeEasingDialog;
import lib.toma.animations.engine.screen.animator.dialog.CopyFrameDialog;
import lib.toma.animations.engine.screen.animator.dialog.EditEventDialog;
import lib.toma.animations.engine.screen.animator.dialog.NewProjectDialog;
import lib.toma.animations.engine.screen.animator.dialog.SaveAsDialog;
import lib.toma.animations.engine.screen.animator.dialog.SettingsDialog;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.ControlButton;
import lib.toma.animations.engine.screen.animator.widget.IconButton;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import lib.toma.animations.engine.screen.animator.widget.Timeline;
import lib.toma.animations.engine.screen.animator.widget.WidgetContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AnimatorScreen
extends Screen {
    public static final DecimalFormat TRANSFORM_FORMAT = new DecimalFormat("0.0##");
    public static final DecimalFormat POSITION_FORMAT = new DecimalFormat("0.0###");
    private static final ITextComponent NEW_PROJECT = new TranslationTextComponent("screen.animator.new_project");
    private static final ITextComponent OPEN = new TranslationTextComponent("screen.animator.open");
    private static final ITextComponent SET_BACKGROUND = new TranslationTextComponent("screen.animator.set_background");
    private static final ITextComponent MERGE = new TranslationTextComponent("screen.animator.append");
    private static final ITextComponent SAVE = new TranslationTextComponent("screen.animator.save");
    private static final ITextComponent SAVE_AS = new TranslationTextComponent("screen.animator.save_as");
    private static final ITextComponent SETTINGS = new TranslationTextComponent("screen.animator.settings");
    private static final ITextComponent PAUSED = new TranslationTextComponent("screen.animator.paused");
    private static final ITextComponent ADD_FRAME = new TranslationTextComponent("screen.animator.timeline.add_frame");
    private static final ITextComponent ADD_EVENT = new TranslationTextComponent("screen.animator.timeline.add_event");
    private static final ITextComponent REMOVE_FRAME = new TranslationTextComponent("screen.animator.timeline.remove_frame");
    private static final ITextComponent COPY_FRAME = new TranslationTextComponent("screen.animator.timeline.copy_frame");
    private static final ITextComponent DUPLICATE_FRAME = new TranslationTextComponent("screen.animator.timeline.duplicate_frame");
    private static final ITextComponent PROGRESS2FRAME = new TranslationTextComponent("screen.animator.timeline.progress2frame");
    private static final ITextComponent SET2BEGINNING = new TranslationTextComponent("screen.animator.timeline.to_beginning");
    private static final ITextComponent SET2END = new TranslationTextComponent("screen.animator.timeline.to_end");
    private static final ITextComponent NEXT_FRAME = new TranslationTextComponent("screen.animator.timeline.next_frame");
    private static final ITextComponent EASING = new TranslationTextComponent("screen.animation.inspector.easing");
    private static final ResourceLocation ANIMATOR_ICONS = new ResourceLocation("textures/icons/animator/animator_icons.png");
    private static final ResourceLocation TIMELINE_ICONS = new ResourceLocation("textures/icons/animator/timeline_icons.png");
    private final Pattern posRotPattern = Pattern.compile("-?[0-9]+(\\.[0-9]*)?");
    private final Pattern endpoint = Pattern.compile("(1(\\.0)?)|(0(\\.[0-9]+)?)");
    @Nullable
    private Timeline.IKeyframeSelectContext selectionContext;
    private WidgetContainer keyframeEditor;
    private TextFieldWidget posX;
    private TextFieldWidget posY;
    private TextFieldWidget posZ;
    private TextFieldWidget rotX;
    private TextFieldWidget rotY;
    private TextFieldWidget rotZ;
    private TextFieldWidget end;
    private Button easing;
    private Timeline timeline;
    private IconButton removeFrame;
    private IconButton copyFrame;
    private IconButton duplicateFrame;
    private IconButton progress2Frame;

    public AnimatorScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.dev_tool.animator"));
    }

    protected void func_231160_c_() {
        IconButton.SETTINGS.set(ANIMATOR_ICONS, 3, 16);
        this.func_230480_a_((Widget)new IconButton(5, 5, 20, 20, 0, this::buttonNewProject_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, NEW_PROJECT, mx, my)));
        this.func_230480_a_((Widget)new IconButton(30, 5, 20, 20, 1, this::buttonOpen_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, OPEN, mx, my)));
        this.func_230480_a_((Widget)new IconButton(55, 5, 20, 20, 4, this::buttonSetBackgroundAnimation, (btn, poses, mx, my) -> this.func_238652_a_(poses, SET_BACKGROUND, mx, my)));
        this.func_230480_a_((Widget)new IconButton(80, 5, 20, 20, 5, this::buttonMerge_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, MERGE, mx, my)));
        Widget widget = this.func_230480_a_((Widget)new IconButton(105, 5, 20, 20, 2, this::buttonSave_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, SAVE, mx, my)));
        widget.field_230693_o_ = false;
        this.func_230480_a_((Widget)new IconButton(130, 5, 20, 20, 2, this::buttonSaveAs_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, SAVE_AS, mx, my)));
        this.func_230480_a_((Widget)new IconButton(155, 5, 20, 20, 3, this::buttonSettings_Clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, SETTINGS, mx, my)));
        this.func_230480_a_(new ControlButton(this.field_230708_k_ - 70, 5, 65, 20, PAUSED, this::isPaused, this::setPaused));
        this.keyframeEditor = (WidgetContainer)this.func_230480_a_(new WidgetContainer(0, this.field_230709_l_ - 175, 140, 95));
        this.keyframeEditor.backgroundColor = 0x40000000;
        this.keyframeEditor.frameSize = 1;
        this.keyframeEditor.frameColor = 0x67000000;
        this.keyframeEditor.addWidget(new LabelWidget(5, 2, 130, 15, (ITextComponent)new StringTextComponent("Keyframe inspector"), this.field_230712_o_));
        this.posX = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 5, 20, 40, 20, StringTextComponent.field_240750_d_));
        this.posX.func_212954_a((Consumer)new SuggestionResponder("X pos", this.posX, this::posX_change));
        this.posY = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 50, 20, 40, 20, StringTextComponent.field_240750_d_));
        this.posY.func_212954_a((Consumer)new SuggestionResponder("Y pos", this.posY, this::posY_change));
        this.posZ = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 95, 20, 40, 20, StringTextComponent.field_240750_d_));
        this.posZ.func_212954_a((Consumer)new SuggestionResponder("Z pos", this.posZ, this::posZ_change));
        this.rotX = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 5, 45, 40, 20, StringTextComponent.field_240750_d_));
        this.rotX.func_212954_a((Consumer)new SuggestionResponder("X rot", this.rotX, this::rotX_change));
        this.rotY = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 50, 45, 40, 20, StringTextComponent.field_240750_d_));
        this.rotY.func_212954_a((Consumer)new SuggestionResponder("Y rot", this.rotY, this::rotY_change));
        this.rotZ = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 95, 45, 40, 20, StringTextComponent.field_240750_d_));
        this.rotZ.func_212954_a((Consumer)new SuggestionResponder("Z rot", this.rotZ, this::rotZ_change));
        this.end = this.keyframeEditor.addWidget(new TextFieldWidget(this.field_230712_o_, 5, 70, 50, 20, StringTextComponent.field_240750_d_));
        this.end.func_212954_a((Consumer)new SuggestionResponder("Pos", this.end, this::endpoint_change));
        this.easing = this.keyframeEditor.addWidget(new Button(60, 70, 75, 20, StringTextComponent.field_240750_d_, this::buttonEasing_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, EASING, mx, my)));
        this.timeline = (Timeline)this.func_230480_a_(new Timeline(0, this.field_230709_l_ - 80, this.field_230708_k_, 80, () -> this.selectionContext));
        this.timeline.setProgressBarClickHandler(this::animationProgressBar_clicked);
        this.timeline.setKeyframeSelectHandler(this::keyframe_select);
        this.timeline.setEventClickHandler(this::event_clicked);
        IconButton.SETTINGS.set(TIMELINE_ICONS, 3, 16);
        this.timeline.addWidget(new IconButton(5, 2, 16, 16, 0, this::buttonAddFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, ADD_FRAME, mx, my)));
        this.removeFrame = this.timeline.addWidget(new IconButton(30, 2, 16, 16, 1, this::buttonRemoveFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, REMOVE_FRAME, mx, my)));
        IconButton addEvent = this.timeline.addWidget(new IconButton(55, 2, 16, 16, 2, this::buttonAddEvent_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, ADD_EVENT, mx, my)));
        this.copyFrame = this.timeline.addWidget(new IconButton(80, 2, 16, 16, 3, this::buttonCopyFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, COPY_FRAME, mx, my)));
        this.duplicateFrame = this.timeline.addWidget(new IconButton(105, 2, 16, 16, 4, this::buttonDuplicateFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, DUPLICATE_FRAME, mx, my)));
        this.progress2Frame = this.timeline.addWidget(new IconButton(130, 2, 16, 16, 5, this::buttonSetProgressToFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, PROGRESS2FRAME, mx, my)));
        this.timeline.addWidget(new IconButton(155, 2, 16, 16, 6, this::resetToBeginning_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, SET2BEGINNING, mx, my)));
        this.timeline.addWidget(new IconButton(180, 2, 16, 16, 7, this::setToEnd_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, SET2END, mx, my)));
        this.timeline.addWidget(new IconButton(205, 2, 16, 16, 8, this::setToNextFrame_clicked, (btn, poses, mx, my) -> this.func_238652_a_(poses, NEXT_FRAME, mx, my)));
        if (!this.timeline.getProject().hasEvents()) {
            addEvent.field_230693_o_ = false;
        }
        this.timeline.playAnimation();
        this.updateSelectionDependents(this.selectionContext != null);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float deltaRenderTime) {
        this.drawToolbarBackground(stack);
        super.func_230430_a_(stack, mouseX, mouseY, deltaRenderTime);
    }

    public boolean func_231046_a_(int keycode, int scancode, int modifiers) {
        switch (keycode) {
            case 32: {
                this.setPaused(!this.isPaused());
                break;
            }
            case 258: {
                this.setToNextFrame_clicked(null);
                break;
            }
            case 334: {
                this.buttonAddFrame_clicked(null);
                break;
            }
            case 332: {
                this.buttonSetProgressToFrame_clicked(null);
            }
        }
        return super.func_231046_a_(keycode, scancode, modifiers);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void setBackgroundAnimation(IKeyframeProvider provider) {
        this.timeline.setBackgroundAnimation(provider);
    }

    public void clearBackgroundAnimation() {
        this.timeline.clearBackgroundAnimation();
    }

    private void posX_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.posX)) {
            this.setPos(value, (old, x) -> new Vector3d(x.doubleValue(), old.field_72448_b, old.field_72449_c));
        }
    }

    private void posY_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.posY)) {
            this.setPos(value, (old, y) -> new Vector3d(old.field_72450_a, y.doubleValue(), old.field_72449_c));
        }
    }

    private void posZ_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.posZ)) {
            this.setPos(value, (old, z) -> new Vector3d(old.field_72450_a, old.field_72448_b, z.doubleValue()));
        }
    }

    private void setPos(String value, BiFunction<Vector3d, Double, Vector3d> setter) {
        double x = Double.parseDouble(value);
        MutableKeyframe keyframe = this.selectionContext.frame();
        Vector3d old = keyframe.position;
        keyframe.setPosition(setter.apply(old, x));
        this.timeline.recompile(this.selectionContext.owner());
    }

    private void rotX_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.rotX)) {
            this.setRotation(value, (vec, d) -> new Vector3d(d.doubleValue(), vec.field_72448_b, vec.field_72449_c));
        }
    }

    private void rotY_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.rotY)) {
            this.setRotation(value, (vec, d) -> new Vector3d(vec.field_72450_a, d.doubleValue(), vec.field_72449_c));
        }
    }

    private void rotZ_change(String value) {
        if (this.tryValidate(value, this.posRotPattern, this.rotZ)) {
            this.setRotation(value, (vec, d) -> new Vector3d(vec.field_72450_a, vec.field_72448_b, d.doubleValue()));
        }
    }

    private void setRotation(String value, BiFunction<Vector3d, Double, Vector3d> setter) {
        double d = Double.parseDouble(value);
        MutableKeyframe keyframe = this.selectionContext.frame();
        Vector3d rotation = keyframe.rotationTarget();
        Vector3d newRot = setter.apply(rotation, d);
        keyframe.setRotation(newRot);
        this.timeline.recompile(this.selectionContext.owner());
    }

    private void endpoint_change(String value) {
        if (this.tryValidate(value, this.endpoint, this.end)) {
            float val = Float.parseFloat(value);
            this.selectionContext.frame().setEndpoint(val);
            this.timeline.getProject().getFrameControl().getProvider().sort(this.selectionContext.owner());
            this.timeline.init();
        }
    }

    private void buttonEasing_clicked(Button button) {
        ChangeEasingDialog screen = new ChangeEasingDialog(this, this::onEasingChanged);
        this.field_230706_i_.func_147108_a((Screen)screen);
    }

    private void onEasingChanged(IEasing easing) {
        this.selectionContext.frame().setEasing(easing);
        this.easing.func_238482_a_((ITextComponent)new StringTextComponent(easing.getEasingName()));
    }

    private boolean tryValidate(String value, Pattern pattern, TextFieldWidget widget) {
        if (pattern.matcher(value).matches()) {
            widget.func_146193_g(0xE0E0E0);
            return true;
        }
        widget.func_146193_g(0xE00000);
        return false;
    }

    private void buttonAddFrame_clicked(Button button) {
        AddFrameDialog dialogScreen = new AddFrameDialog(this, this.timeline.getAnimationProgress(), this::addFrames);
        this.field_230706_i_.func_147108_a((Screen)dialogScreen);
    }

    private void addFrames(float progress, List<AnimationStage> frameOwners) {
        AnimationStage lastStage = null;
        MutableKeyframe mutable = null;
        AnimationProject.AnimationController controller = Animator.get().getProject().getAnimationControl();
        Iterator<AnimationStage> iterator = frameOwners.iterator();
        while (iterator.hasNext()) {
            AnimationStage stage;
            lastStage = stage = iterator.next();
            mutable = new MutableKeyframe();
            mutable.setEndpoint(progress);
            mutable.setEasing(controller.getEasing());
            this.timeline.add(stage, mutable);
        }
        this.timeline.init();
        if (lastStage != null && mutable != null) {
            this.keyframe_select(Timeline.IKeyframeSelectContext.of(mutable, lastStage));
        }
    }

    private void buttonRemoveFrame_clicked(Button button) {
        this.timeline.remove(this.selectionContext.owner(), this.selectionContext.frame());
        this.timeline.init();
    }

    private void buttonAddEvent_clicked(Button button) {
        AddEventDialog dialog = new AddEventDialog(this, this.timeline.getAnimationProgress(), this.timeline::add);
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void buttonCopyFrame_clicked(Button button) {
        CopyFrameDialog dialog = new CopyFrameDialog(this, this::copyFrames, this.selectionContext.owner());
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void buttonDuplicateFrame_clicked(Button button) {
        MutableKeyframe keyframe = this.selectionContext.frame();
        MutableKeyframe duplicated = MutableKeyframe.copyOf(keyframe);
        duplicated.setEndpoint(Math.min(keyframe.endpoint() + 0.05f, 1.0f));
        this.timeline.add(this.selectionContext.owner(), duplicated);
        this.timeline.init();
        this.keyframe_select(Timeline.IKeyframeSelectContext.of(duplicated, this.selectionContext.owner()));
    }

    private void copyFrames(List<AnimationStage> targets) {
        for (AnimationStage stage : targets) {
            MutableKeyframe kf = MutableKeyframe.copyOf(this.selectionContext.frame());
            this.timeline.add(stage, kf);
        }
        this.timeline.init();
    }

    private void buttonSetProgressToFrame_clicked(Button button) {
        this.timeline.getAnimation().setProgress(this.selectionContext.frame().endpoint());
    }

    private void resetToBeginning_clicked(Button button) {
        this.timeline.getAnimation().setProgress(0.0f);
    }

    private void setToEnd_clicked(Button button) {
        this.timeline.getAnimation().setProgress(1.0f);
    }

    private void setToNextFrame_clicked(Button button) {
        AnimationProject project = this.timeline.getProject();
        AnimatorFrameProvider provider = project.getFrameControl().getProvider();
        Map<AnimationStage, List<MutableKeyframe>> frames = provider.getFrames();
        float currentProgress = this.timeline.getAnimationProgress();
        if (currentProgress == 1.0f) {
            currentProgress = 0.0f;
        }
        List list = frames.entrySet().stream().flatMap(this::doMapping).sorted(Timeline.IKeyframeSelectContext::compareTo).collect(Collectors.toList());
        Timeline.IKeyframeSelectContext next = null;
        for (Timeline.IKeyframeSelectContext context : list) {
            if (!(context.frame().endpoint() > currentProgress)) continue;
            next = context;
            break;
        }
        float value = next != null ? next.frame().endpoint() : 1.0f;
        this.timeline.getAnimation().setProgress(value);
        if (next != null) {
            this.keyframe_select(next);
        }
    }

    private void animationProgressBar_clicked(float value) {
        this.timeline.getAnimation().setProgress(value);
    }

    private void keyframe_select(Timeline.IKeyframeSelectContext context) {
        this.selectionContext = context;
        this.updateSelectionDependents(this.selectionContext != null);
    }

    private void event_clicked(IAnimationEvent event) {
        EditEventDialog screen = new EditEventDialog(this, event, this.timeline::replace);
        this.field_230706_i_.func_147108_a((Screen)screen);
    }

    private void updateSelectionDependents(boolean hasFrame) {
        this.keyframeEditor.field_230694_p_ = hasFrame;
        this.removeFrame.field_230693_o_ = hasFrame;
        this.copyFrame.field_230693_o_ = hasFrame;
        this.duplicateFrame.field_230693_o_ = hasFrame && this.selectionContext.frame().endpoint() <= 0.95f;
        this.progress2Frame.field_230693_o_ = hasFrame;
        if (hasFrame) {
            MutableKeyframe frame = this.selectionContext.frame();
            Vector3d position = frame.positionTarget();
            Vector3d rotation = frame.rotationTarget();
            this.posX.func_146180_a(TRANSFORM_FORMAT.format(position.field_72450_a));
            this.posY.func_146180_a(TRANSFORM_FORMAT.format(position.field_72448_b));
            this.posZ.func_146180_a(TRANSFORM_FORMAT.format(position.field_72449_c));
            this.rotX.func_146180_a(TRANSFORM_FORMAT.format(rotation.func_82615_a()));
            this.rotY.func_146180_a(TRANSFORM_FORMAT.format(rotation.func_82617_b()));
            this.rotZ.func_146180_a(TRANSFORM_FORMAT.format(rotation.func_82616_c()));
            this.end.func_146180_a(POSITION_FORMAT.format(frame.endpoint()));
            this.easing.func_238482_a_((ITextComponent)new StringTextComponent(frame.getEasing().getEasingName()));
        }
    }

    private void drawToolbarBackground(MatrixStack stack) {
        int toolbarHeight = 30;
        AnimatorScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)0, (int)this.field_230708_k_, (int)toolbarHeight, (int)0x67000000);
    }

    private void buttonNewProject_Clicked(Button button) {
        NewProjectDialog dialog = new NewProjectDialog(this);
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void buttonOpen_Clicked(Button button) {
        this.field_230706_i_.func_147108_a((Screen)new ImportProjectScreen(this, this::clearBackgroundAnimation));
    }

    private void buttonSetBackgroundAnimation(Button button) {
        this.field_230706_i_.func_147108_a((Screen)new SetBackgroundAnimationScreen(this, this::clearBackgroundAnimation, this::setBackgroundAnimation));
    }

    private void buttonMerge_Clicked(Button button) {
        this.field_230706_i_.func_147108_a((Screen)new MergeAnimationScreen(this));
    }

    private void buttonSave_Clicked(Button button) {
        Animator animator = Animator.get();
        AnimationProject project = animator.getProject();
        if (project.isNamed()) {
            project.saveProject();
        } else {
            this.buttonSaveAs_Clicked(button);
        }
    }

    private void buttonSaveAs_Clicked(Button button) {
        SaveAsDialog dialog = new SaveAsDialog(this);
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void buttonSettings_Clicked(Button button) {
        SettingsDialog dialog = new SettingsDialog(this);
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private boolean isPaused() {
        return Animator.get().getProject().getAnimationControl().isPaused();
    }

    private void setPaused(boolean paused) {
        Animator.get().getProject().getAnimationControl().setPaused(paused);
    }

    private Stream<Timeline.IKeyframeSelectContext> doMapping(Map.Entry<AnimationStage, List<MutableKeyframe>> entry) {
        ArrayList<Timeline.IKeyframeSelectContext> list = new ArrayList<Timeline.IKeyframeSelectContext>();
        for (MutableKeyframe frame : entry.getValue()) {
            list.add(Timeline.IKeyframeSelectContext.of(frame, entry.getKey()));
        }
        return list.stream();
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ROOT);
        TRANSFORM_FORMAT.setDecimalFormatSymbols(symbols);
        POSITION_FORMAT.setDecimalFormatSymbols(symbols);
    }
}

